import json
import sys
sys.path.insert(0, '/var/www/cgi-bin')
import logging_rpi
import BackhaulConfiguration
from BackhaulSubscribe import BackhaulSubscribe
from Backhaul import Backhaul

class BackhaulListener(BackhaulSubscribe):

    def __init__(self):
        BackhaulSubscribe.__init__(self)
        self.backhaul = Backhaul("privateQueue")
        self.queueName = "privateQueue"
        self.publish = False
        self.topic =  BackhaulConfiguration.getConfigurationTopic()
        print("Listening to " + str(self.topic))

    def pulsarMain(self):
        data = self.data
        data['Topic'] = data['Module']
        
        try:
            logging_rpi.log.info("PulsarSubscriber:::Data Retrieved from Pulsar:::Module: " + str(data['Module']))
            print "==============================================="
            print("Queuing {0} to privateQueue.".format(data['Topic']))
            print(self.backhaul.send(data))
            return True
        except KeyError as e:
            logging_rpi.log.error("PulsarSubscriber:::Format Error::: Topic does not match format.")
        return False

if __name__ == '__main__':

    try:
        logging_rpi.log.info("PulsarSubscriber:::Started PulsarSubscriber:::")
        backhaulListener = BackhaulListener()
        backhaulListener.listenPulsar(override=True)
    except KeyboardInterrupt as e:
        print("\nStopped Listening to Pulsar. Exiting...")